/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1995  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/ 
`delay_mode_path
`timescale 1 ns / 1 ns
`ifdef SYNTH
`else
`celldefine
`endif
module lpm_tff ( q,
        data, clock, enable,
        aclr, aset, aconst, aload,
        sclr, sset, sconst, sload) ;

  parameter lpm_type = "lpm_tff" ;
  parameter lpm_width  = 1 ;
  parameter lpm_avalue = 0 ;
  parameter lpm_svalue = 0 ;
  parameter polar_data     = "NORMAL" ;
  parameter polar_clock    = "NORMAL" ;
  parameter polar_enable   = "NORMAL" ;
  parameter polar_aclr     = "NORMAL" ;
  parameter polar_aset     = "NORMAL" ;
  parameter polar_aconst   = "NORMAL" ;
  parameter polar_aload    = "NORMAL" ;
  parameter polar_sclr     = "NORMAL" ;
  parameter polar_sset     = "NORMAL" ;
  parameter polar_sconst   = "NORMAL" ;
  parameter polar_sload    = "NORMAL" ;
  parameter polar_q        = "NORMAL" ;

  input  [lpm_width-1:0] data ;
  input  clock, enable ;
  input  aclr, aset, aconst ;
  input  sclr, sset, sconst ;
  input  sload, aload ;
  output [lpm_width-1:0] q;


  // inernal reg 
  reg   [lpm_width-1:0] tmp_q ;
  reg   [lpm_width-1:0] pdata ;
  reg   pclock, penable, psload, paload ;
  reg   paclr, paset, paconst ;
  reg   psset, psclr, psconst ;
  reg   [lpm_width-1:0] ONES ;
  integer i ;

  wire aset_in, aclr_in, aconst_in, aload_in ;
  wire sset_in, sclr_in, sconst_in, sload_in ;
  wire enable_in ;

  nmos N1 ( aset_in, aset, 1'b1) ;
  pulldown P1 ( aset_in) ;
  nmos N2 ( aclr_in, aclr, 1'b1) ;
  pulldown P2 ( aclr_in) ;
  nmos N3 ( aconst_in, aconst, 1'b1) ;
  pulldown P3 ( aconst_in) ;
  nmos N4 ( aload_in, aload, 1'b1) ;
  pulldown P4 ( aload_in) ;
  nmos N5 ( sset_in, sset, 1'b1) ;
  pulldown P5 ( sset_in) ;
  nmos N6 ( sclr_in, sclr, 1'b1) ;
  pulldown P6 ( sclr_in) ;
  nmos N7 ( sconst_in, sconst, 1'b1) ;
  pulldown P7 ( sconst_in) ;
  nmos N8 ( sload_in, sload, 1'b1) ;
  pulldown P8 ( sload_in) ;
  nmos N9 ( enable_in, enable, 1'b1) ;
  pullup   P9 ( enable_in) ;

  initial
  begin
	for(i=0; i < lpm_width; i=i+1)
		ONES[i] = 1'b1 ;

    tmp_q = 0 ;

    // check if module has valid configuration
  
    if(((aset !== 1'bz) || (aclr !== 1'bz) || (aload !== 1'bz))
      &&(aconst !== 1'bz))
          $display("Error! If aset or aclr is used, aconst must not be used.");
 
    if(((sset !== 1'bz) || (sclr !== 1'bz) || (sload !== 1'bz))
        &&(sconst !== 1'bz))
          $display("Error! If sset or sclr is used, sconst must not be used.");

  end

 always @(aset_in)
      paset   <= (polar_aset == "INVERT")?~aset_in:aset_in ;
 
  always @(aclr_in)
      paclr   <= (polar_aclr == "INVERT")?~aclr_in:aclr_in ;
 
  always @(aconst_in)
      paconst <= (polar_aconst == "INVERT")?~aconst_in:aconst_in ;
 
  always @(aload_in)
      paload  <= (polar_aload == "INVERT")?~aload_in:aload_in ;
 
  always @(sset_in)
      psset   <= #1 (polar_sset == "INVERT")?~sset_in:sset_in ;
 
  always @(sclr_in)
      psclr   <= #1 (polar_sclr == "INVERT")?~sclr_in:sclr_in ;
 
  always @(sconst_in)
      psconst <= #1 (polar_sconst == "INVERT")?~sconst_in:sconst_in ;

  always @(sload_in)
      psload  <= #1 (polar_sload == "INVERT")?~sload_in:sload_in ;

  always @(enable_in)
	  penable <= #1 (polar_enable == "INVERT")?~enable_in:enable_in ;

  always @(clock)
      pclock  <= #1 (polar_clock == "INVERT")?~clock:clock ;

  always @(data)
	pdata   <= #1 (polar_data == "INVERT")?~data:data;
	
  
  always @( pdata or paclr or paset or paconst or paload)
    begin  :asyn_block // Asynchronous process
      if (paclr)
		begin
         assign tmp_q = 0 ;
		end
      else if (paset)
		begin
         assign tmp_q = ONES ;
		end
      else if (paconst)
		begin
            // check if avalue is out of bound
            if(lpm_avalue >= (1 << lpm_width))
                $display("Error! lpm_avalue is out of bound.\n");
            else if(lpm_avalue < 0)
                $display("Error! lpm_avalue must be a positive value.\n");
            else
         		assign tmp_q = lpm_avalue ;
		end
      else if (paload)
		begin
         assign tmp_q = pdata ;
		end
	  else
		begin
		  deassign tmp_q ;
		end
	end

  always @(posedge pclock)
    begin  :syn_block // Synchronous process
      if (penable)
	    begin
			if(psclr)
			  begin :syn_clr
				if(paclr)
					disable syn_clr ;
        		else
					tmp_q = 0;
			  end
      		else if (psset)
			  begin :syn_set
				if(paset)
					disable syn_set ;
        		else	
					tmp_q = ONES ;
			  end
      		else if (psconst)
			  begin :syn_const
				if(paconst)
					disable syn_const ;
        		else
              	  begin
                	// check if svalue is out of bound
                	if(lpm_svalue >= (1 << lpm_width))
                    	$display("Error! lpm_svalue is out of bound.\n");
                	else if(lpm_svalue < 0)
                    	$display("Error! lpm_svalue must be a positive value.\n");
                	else
                    	tmp_q = lpm_svalue ;
              	  end
			  end
      		else if (psload)  // Load data
			  begin :syn_load
				if(paload)
					disable syn_load ;
        		else
					tmp_q = pdata ;
			  end
      		else 			  // tff behavior
       		  begin
				tmp_q = pdata ^ tmp_q ;
        	  end
		  end
	  end

  assign q = (polar_q == "INVERT")?~tmp_q:tmp_q ;

endmodule // lpm_tff
`ifdef SYNTH
`else
`endcelldefine
`endif
 
